clear
close all
clc
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultLegendInterpreter','latex'); %trying to set the default

%% Data importing
load Spiral_static.mat
load Step_static.mat
load Tapered_static.mat
load Wedge_static.mat

h_vec = h_vec_tapered;
%% Ploting
figure
hold on
plot(h_vec_spiral*1e6,W_spiral)
plot(h_vec_step*1e6,W_step)
plot(h_vec_tapered*1e6,W_tapered)
plot(h_vec_wedge*1e6,W_wedge)
hold off
xlabel('Air gap $h$ [$\mu m$]')
ylabel('Load capacity $W$ [$N$]')
title('Load capacity at minimum rotational speed $\omega_{min} = 5\, krpm$')
legend('Spiral','Step','Tapered','Slider')
grid on
figureEditor


